/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.cfg;

import com.sun.enterprise.glassfish.bootstrap.log.LogFacade;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AsenvConf {
    private static final Pattern LINE = Pattern.compile("(?i)(set +)?([^=]*)=\"?([^\"]*)\"?");
    private final Properties properties = new Properties();

    private AsenvConf(File asenv, File configDir) {
        if (!asenv.exists()) {
            LogFacade.BOOTSTRAP_LOGGER.log(Level.FINE, "{0} not found, ignoring", asenv.getAbsolutePath());
            return;
        }
        try (LineNumberReader lnReader = new LineNumberReader(new FileReader(asenv, StandardCharsets.UTF_8));){
            String line = lnReader.readLine();
            while (line != null) {
                Matcher m = LINE.matcher(line);
                if (m.matches()) {
                    File configFile = new File(m.group(3));
                    if (!configFile.isAbsolute()) {
                        configFile = new File(configDir, m.group(3));
                        if (configFile.exists()) {
                            this.properties.put(m.group(2), configFile.getAbsolutePath());
                        } else {
                            this.properties.put(m.group(2), m.group(3));
                        }
                    } else {
                        this.properties.put(m.group(2), m.group(3));
                    }
                }
                line = lnReader.readLine();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error opening asenv.conf file.", ioe);
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void mirrorToSystemProperties() {
        for (String name : this.properties.stringPropertyNames()) {
            System.setProperty(name, this.properties.getProperty(name));
        }
    }

    public Properties toProperties() {
        return (Properties)this.properties.clone();
    }

    public static AsenvConf parseAsEnv(File installRoot) {
        File configDir = new File(installRoot, "config");
        File asenv = AsenvConf.getAsEnvConf(configDir);
        return new AsenvConf(asenv, configDir);
    }

    private static File getAsEnvConf(File configDir) {
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows")) {
            return new File(configDir, "asenv.bat");
        }
        return new File(configDir, "asenv.conf");
    }
}

